* Definicia indexovych mnozin
Set i /1*10/
    k /1*5000/
    n /1*5000/
    s /GJM,ALT/;

alias(i,j);

* Definicia parameterov
Parameter A1(i,j),B1(i,j),y1(i),x1(j),u1(i),v1(j),
          A0(i,j),B0(i,j),y0(i),x0(j),u0(i),v0(j),
          MAD_A(n,s),SEM_A(n,s),
          MAD_B(n,s),SEM_B(n,s),
          MaxPE(n,s),MAPE(n,s),
          GOF_A(n,s),GOF_B(n,s),
          CORR_A(n,s),CORR_B(n,s),
          mean_A1_HAT(s),mean_A1,
          mean_B1_HAT(s),mean_B1,
          mean0(n),mean1(n),
          stddev0(n),stddev1(n);

Scalar F,G1,N1,N2;
    N1=sum((i,j), 1);
    N2=sum(n, 1);

* Definicia premennych a rovnic
Variables
    lambda(i)
    mi(j)
    M       entropy;

Equations
    obj_gjm    define objective function - golan & judge & miller
    obj_alt    define objective function - alternative ;

    obj_gjm..    M =e= sum(i, lambda(i)*u1(i))
                     + sum(j, log(sum(i, exp(-lambda(i)*v1(j)))));

    obj_alt..    M =e= sum(i, lambda(i)*u1(i))
                     + sum(j, mi(j)*v1(j))
                     + log(sum((i,j), exp(-(lambda(i)+mi(j))*G1)));

Model IO_GJM /obj_gjm/ ;
Model IO_ALT /obj_alt/ ;

option NLP=CONOPT;

Parameter omega1(j),omega2,
          A1_HAT(i,j,s),B1_HAT(i,j,s),
          E_A(i,j,s),
          E_B(i,j,s),
          P_B(i,j,s);

*loop(k,
*    B0(i,j)=uniform(0,100);
*    y0(i)=uniform(0,100);
*    B1(i,j)=abs(normal(1.1,0.25))*B0(i,j);
*    y1(i)=abs(normal(1.1,0.25))*y0(i);
*    );

* MC simulacie
loop(n,

    B0(i,j)=uniform(0,10);
    y0(i)=uniform(0,10);
    u0(i)=sum(j, B0(i,j));
    v0(j)=sum(i, B0(i,j));

    x0(i)=u0(i)+y0(i);

    loop(i,
         if (v0(i)>=x0(i),
            x0(i)=v0(i)+y0(i);
            y0(i)=x0(i)-u0(i);
            );
         );

    A0(i,j)=B0(i,j)/x0(j);

    B1(i,j)=abs(normal(1.3,0.75))*B0(i,j);
    y1(i)=abs(normal(1.3,0.75))*y0(i);
    u1(i)=sum(j, B1(i,j));
    v1(j)=sum(i, B1(i,j));

    x1(i)=u1(i)+y1(i);
    loop(i,
         if (v1(i)>=x1(i),
            x1(i)=v1(i)+y1(i);
            y1(i)=x1(i)-u1(i);
            );
         );

    A1(i,j)=B1(i,j)/x1(j);

    G1=sum(i, u1(i));

    F=G1/5;
    G1=G1/F;

    v1(j)=v1(j)/F;
    u1(i)=u1(i)/F;

    if(1=1,

    lambda.l(i) = 0;
    mi.l(j) = 0;

    solve IO_GJM using NLP minimizing M;

       omega1(j)=sum(i, exp(-lambda.l(i)*v1(j)));
       A1_HAT(i,j,'GJM')=F*v1(j)/x1(j)*exp(-lambda.l(i)*v1(j))/omega1(j);
       B1_HAT(i,j,'GJM')=A1_HAT(i,j,'GJM')*x1(j);

    lambda.l(i) = 0;
    mi.l(j) = 0;

    solve IO_ALT using NLP minimizing M;

       omega2=sum((i,j), exp(-(lambda.l(i)+mi.l(j))*G1));
       A1_HAT(i,j,'ALT')=F*G1/x1(j)*exp(-(lambda.l(i)+mi.l(j))*G1)/omega2;
       B1_HAT(i,j,'ALT')=A1_HAT(i,j,'ALT')*x1(j);

       E_A(i,j,s) = A1_HAT(i,j,s)-A1(i,j);
       E_B(i,j,s) = B1_HAT(i,j,s)-B1(i,j);
       P_B(i,j,s)$B1(i,j) = abs(E_B(i,j,s))/B1(i,j);

       MAD_A(n,s) = sum((i,j), abs(E_A(i,j,s)))/N1;
       SEM_A(n,s) = sum((i,j), power(E_A(i,j,s),2))/N1;
       GOF_A(n,s) = sum((i,j), power(E_A(i,j,s),2)/(N1*A1_HAT(i,j,s)));
       mean_A1_HAT(s)=sum((i,j), A1_HAT(i,j,s))/N1;
       mean_A1=sum((i,j), A1(i,j))/N1;
       CORR_A(n,s) = (sum((i,j),(A1_HAT(i,j,s)-mean_A1_HAT(s))*(A1(i,j)-mean_A1))/N1)/
         ((sum((i,j),power(A1_HAT(i,j,s)-mean_A1_HAT(s),2))/N1)*(sum((i,j),power(A1(i,j)-mean_A1,2))/N1))**0.5;

       MAD_B(n,s) = sum((i,j), abs(E_B(i,j,s)))/N1;
       SEM_B(n,s) = sum((i,j), power(E_B(i,j,s),2))/N1;
       GOF_B(n,s) = sum((i,j), power(E_B(i,j,s),2)/(N1*B1_HAT(i,j,s)));
       mean_B1_HAT(s)=sum((i,j), B1_HAT(i,j,s))/N1;
       mean_B1=sum((i,j), B1(i,j))/N1;
       CORR_B(n,s) = (sum((i,j),(B1_HAT(i,j,s)-mean_B1_HAT(s))*(B1(i,j)-mean_B1))/N1)/
         ((sum((i,j),power(B1_HAT(i,j,s)-mean_B1_HAT(s),2))/N1)*(sum((i,j),power(B1(i,j)-mean_B1,2))/N1))**0.5;

       MaxPE(n,s) = smax((i,j), P_B(i,j,s));
       MAPE(n,s) = sum((i,j), P_B(i,j,s))/N1;

    mean0(n)=sum((i,j), b0(i,j))/N1;
    mean1(n)=sum((i,j), b1(i,j))/N1;
    stddev0(n)=sum((i,j), power((b0(i,j)-mean0(n)),2))/N1;
    stddev1(n)=sum((i,j), power((b1(i,j)-mean1(n)),2))/N1;
              );

   );

* Vypocet parametrov
Parameter MAD_A_AVG(s),SEM_A_AVG(s),
          MAD_B_AVG(s),SEM_B_AVG(s),
          MaxPE_AVG(s),MAPE_AVG(s),
          GOF_A_AVG(s),GOF_B_AVG(s),
          CORR_A_AVG(s),CORR_B_AVG(s),
          mean0_avg,mean1_avg,
          stddev0_avg,stddev1_avg;

   MAD_A_AVG(s)=sum(n, MAD_A(n,s))/N2;
   SEM_A_AVG(s)=sum(n, SEM_A(n,s))/N2;
   GOF_A_AVG(s)=sum(n, GOF_A(n,s))/N2;
   CORR_A_AVG(s)=sum(n, CORR_A(n,s))/N2;
   MAD_B_AVG(s)=sum(n, MAD_B(n,s))/N2;
   SEM_B_AVG(s)=sum(n, SEM_B(n,s))/N2;
   GOF_B_AVG(s)=sum(n, GOF_B(n,s))/N2;
   CORR_B_AVG(s)=sum(n, CORR_B(n,s))/N2;

   MaxPE_AVG(s)=sum(n, MaxPE(n,s))/N2;
   MAPE_AVG(s)=sum(n, MAPE(n,s))/N2;

   mean0_avg=sum(n, mean0(n))/N2;
   mean1_avg=sum(n, mean1(n))/N2;

   stddev0_avg=sum(n, stddev0(n))/N2;
   stddev1_avg=sum(n, stddev1(n))/N2;

option decimals = 5

Display MAD_A_AVG,SEM_A_AVG,
        MAD_B_AVG,SEM_B_AVG,
        MaxPE_AVG,MAPE_AVG,
        GOF_A_AVG,GOF_B_AVG,
        CORR_A_AVG,CORR_B_AVG,
        mean0_avg,mean1_avg,
        stddev0_avg,stddev1_avg;